unit Servunit;

{
 Delphi Socket Server example
 Author  : Dirk Claessens
 FREEWARE
}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ScktComp, StdCtrls;

type
  TForm1 = class(TForm)
    ServSock: TServerSocket;
    Memo1: TMemo;
    btnBroadcast: TButton;
    CbEcho: TCheckBox;
    Edit1: TEdit;
    StaticText1: TStaticText;
    Edit2: TEdit;
    procedure ServSockClientConnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ServSockClientDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ServSockClientRead(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ServSockListen(Sender: TObject; Socket: TCustomWinSocket);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnBroadcastClick(Sender: TObject);
    procedure ServSockClientError(Sender: TObject;
      Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
      var ErrorCode: Integer);
  private
    { Private declarations }
  public
    { Public declarations }

  end;

  procedure SockRead( Socket: TCustomWinSocket;
                        var pMem: Pointer;
                        var SizeRead: integer);
var
  Form1: TForm1;

implementation


{$R *.DFM}

//------------------------------------------
procedure SockRead( Socket     : TCustomWinSocket;
                   var pMem    : Pointer;
                   var SizeRead: integer);
var
 Stream    : TMemoryStream;
 BlockSize : integer;
begin
  // Win32 frequently calls with  length 0...
  if Socket.Receivelength > 0 then
  begin
    BlockSize := Socket.ReceiveLength;
    Stream    := TMemoryStream.Create;
    pMem      := AllocMem( BlockSize );
    // loop until all read
    while BlockSize > 0 do
    begin
      Socket.ReceiveBuf( pMem^, BlockSize ); // read block
      Stream.Write( pMem^, BlockSize );      // concat. to stream
      BlockSize := Socket.ReceiveLength;
      if BlockSize > 0 then                 // anymore blocks?
       ReAllocMem(pMem, BlockSize)          // prepare for next bloc
    end;
    Stream.Position := 0;
    ReAllocMem ( pMem, Stream.Size );     // now reallocate all blocks
    Stream.Read( pMem^, Stream.Size );    // copy > pointer memory
    SizeRead := Stream.Size;
    Stream.Free;
  end
  else begin
   pMem := nil;
   SizeRead := 0;
  end;
end;

//===================================================================
procedure TForm1.FormCreate(Sender: TObject);
begin
  ServSock.Active := true;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  ServSock.Close;
end;


//=======================SERVER======================================
procedure TForm1.ServSockClientConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
   with Socket do
   Memo1.Lines.Add('connected with: <' + RemoteHost+'> ['+RemoteAddress+']');
   Edit2.Text := IntToStr( ServSock.Socket.ActiveConnections );
end;

//=======================================================
procedure TForm1.ServSockClientDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  with Socket do
     memo1.lines.add('disconnect: <' + RemoteHost+'> ['+RemoteAddress+']');
  Edit2.Text := IntToStr( ServSock.Socket.ActiveConnections );
end;


//=================================================
procedure TForm1.ServSockClientRead(Sender: TObject;
  Socket: TCustomWinSocket);
var
 sBuf      : string;
 pData     : pointer;
 Size      : integer;
begin
  // pointer is initialised by SockRead() procedure
  SockRead( Socket, pData, Size );
  if Size > 0 then
  begin
   SetLength( sBuf, Size );
   Move( pData^, sBuf[1], Size);  // copy socket buffer to string
   memo1.lines.add('received from ' + Socket.remotehost+ ':' +sBuf);
   FreeMem(pData); //NEVER FORGET THIS! or you'll cause a memory leak!
   if cbEcho.State = cbCHECKED then
       Socket.SendText( 'echo:' + sBuf );
  end;
end;



//-----------------------------------------------------------------------
procedure TForm1.ServSockListen(Sender: TObject; Socket: TCustomWinSocket);
begin
 with Socket do
     Memo1.Lines.Add( LocalHost + ' [' +LocalAddress + '] listening on port '
                   + IntToStr(LocalPort) + '...');
end;


procedure TForm1.btnBroadcastClick(Sender: TObject);
VAR
 i : integer;
begin
 if ServSock.Socket.ActiveConnections > 0 then
 for i := 0 to pred(ServSock.Socket.ActiveConnections) do
  ServSock.Socket.Connections[i].SendText( Edit1.Text );
end;

//==================================================
procedure TForm1.ServSockClientError(Sender: TObject;
  Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
  var ErrorCode: Integer);
begin
   ErrorCode := 0;
   memo1.lines.add( 'IP-error :' + IntToStr(integer(ErrorEvent)));
end;

end.
